/*
 * ResizeFonts
 * @package Joomla 3.2
 * @copyright (c) 2014 Internetagentur Khler. All rights reserved.
 * @license GNU/GPL version 2 or later
 */
var check = false;
var defSize = 100;
var curSize = 100;

function setDefaultSize(defaultSize){
	defSize = defaultSize;
	curSize = defSize;
};

function defaultSize(){
	curSize = defSize;
	changeSize(0);
};

function changeSize(dif){
	curSize = parseInt(curSize) + parseInt(dif * 10);

	if(curSize > 160){
		curSize = 160;
	}else if(curSize < 60){
		curSize = 60;
	}
	setSize(curSize);
};

function setSize(curSize){
	var stObj = (document.getElementById) ? document.getElementById('content_area') : document.all('content_area');
	document.body.style.fontSize = curSize + '%';
};

function createCookie(value) {
	var d = new Date();
	d.setTime(d.getTime()+(365*24*60*60*1000));
	var expires = "expires="+d.toGMTString();
	document.cookie = "resizefonts="+value+"; "+expires+"; path=/";
};

function readCookie() {
	  var name = "resizefonts=";
	  var returnvalue = null;
	  var cookie = document.cookie.split(';');
	  for(var i=0;i < cookie.length;i++) {
	    var cookiepart = cookie[i];
	    while (cookiepart.charAt(0)==' '){
	    	cookiepart = cookiepart.substring(1,cookiepart.length);
	    }
	    if (cookiepart.indexOf(name) == 0) 
	    {
	    	returnvalue = cookiepart.substring(name.length,cookiepart.length);
	    }
	  }
	  return returnvalue;
};

function loadSettings(){
	if(!check){
		cookie = readCookie();
		curSize = cookie ? cookie : defSize;
		setSize(curSize);
		check = true;
	}
};

function saveSettings()
{
	createCookie(curSize);
};

window.onload = loadSettings;
window.onunload = saveSettings;
